/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.URISplit;
import org.das2.datum.DatumRange;
import org.das2.datum.LoggerManager;
import org.das2.fsm.FileStorageModel;
import org.das2.util.filesystem.FileSystem;

public class CacheCleanup {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot");

    private CacheCleanup() {
    }

    private static int numberOfLines(File filePath) throws IOException {
        int numOfLines = 0;
        try (BufferedReader bf = new BufferedReader(new FileReader(filePath));){
            while (bf.readLine() != null) {
                ++numOfLines;
            }
        }
        return numOfLines;
    }

    public static String[] findAggs() throws IOException {
        File filePath = new File(AutoplotSettings.settings().resolveProperty("autoplotData") + "/bookmarks/history.txt");
        ArrayList<String> result = new ArrayList<String>(100);
        int numOfLines = CacheCleanup.numberOfLines(filePath);
        String[] data = new String[numOfLines];
        try (BufferedReader bf = new BufferedReader(new FileReader(filePath));){
            for (int i = 0; i < numOfLines; ++i) {
                String[] parts;
                data[i] = bf.readLine();
                boolean hasAgg = data[i].contains("$Y");
                if (!hasAgg) continue;
                int iq = data[i].indexOf(63);
                int iy = data[i].indexOf("$Y");
                if (iq != -1 && iq <= iy || (parts = data[i].split("\\s+")).length <= 1) continue;
                result.add(parts[1]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] findOldVersions() throws IOException {
        String[] aggs = CacheCleanup.findAggs();
        ArrayList<String> oldversions = new ArrayList<String>(1000);
        FileSystem.settings().setOffline(true);
        for (String agg : aggs) {
            File[] ff;
            URI fileagguri = URISplit.parse((String)agg).resourceUri;
            String fileagg = fileagguri.toString();
            int i = FileStorageModel.splitIndex((String)fileagg);
            String constantPart = fileagg.substring(0, i);
            String templatePart = fileagg.substring(i);
            FileSystem fs = FileSystem.create((String)constantPart);
            FileStorageModel fsm = FileStorageModel.create((FileSystem)fs, (String)templatePart);
            String localRoot = fsm.getFileSystem().getLocalRoot().toString();
            for (File ff1 : ff = fsm.getFilesFor(null)) {
                DatumRange tr = fsm.getRangeFor(ff1.toString().substring(localRoot.length() + 1));
                File[] fbest = fsm.getBestFilesFor(tr);
                if (ff1.toString().equals(fbest[0].toString())) continue;
                oldversions.add(ff1.toString());
            }
        }
        String[] result = oldversions.size() > 0 ? oldversions.toArray(new String[oldversions.size()]) : new String[]{"No Old Versions"};
        FileSystem.settings().setOffline(false);
        return result;
    }

    public static void deleteOldVersions() throws ParseException, IOException {
        String[] oldversions = CacheCleanup.findOldVersions();
        logger.warning("deleteOldVersions not implemented ");
        System.err.println("oldversions:");
        for (String s : oldversions) {
            System.err.println("  " + s);
        }
    }
}

